package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 查询MQTT
 * @date 2021/11/410:29
 */
public class X0105_SMQTTStatus extends ICMD {

    // 设备唯一标识
    private String uid;

    // 连接状态
    private Character status;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.uid)
                .append(this.status);
    }

    @Override
    public void fillingSub() {
        this.uid = super.parseText();
        this.status = super.parseChar();
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Character getStatus() {
        return status;
    }

    public void setStatus(Character status) {
        this.status = status;
    }
}
