package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 5.6 绑定连接1（Server0）：端服双向
 * @date 2021/11/410:29
 */
public class X0106_SBind1 extends ICMD {

    // 设备唯一标识
    private Integer r1;

    // 设备名
    private String r1qr;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.r1, 8)
                .append(this.r1qr);
    }

    @Override
    public void fillingSub() {
        this.r1 = super.parseInt(8);
        this.r1qr = super.parseText();
    }

    public Integer getR1() {
        return r1;
    }

    public void setR1(Integer r1) {
        this.r1 = r1;
    }

    public String getR1qr() {
        return r1qr;
    }

    public void setR1qr(String r1qr) {
        this.r1qr = r1qr;
    }
}
