package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 5.7 绑定连接2（Server0）：端服双向
 * @date 2021/11/410:29
 */
public class X0107_SBind2 extends ICMD {

    // 设备唯一标识
    private String uid;

    // 设备名
    private String user;

    // 设备密码
    private String password;

    // 连接分发域名
    private String domain;

    // 心跳间隔
    private Integer keepAlive;

    // 随机数
    private String random;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.uid)
                .append(this.user)
                .append(this.password)
                .append(this.domain)
                .append(this.keepAlive, 4)
                .appendHex(random);
    }

    @Override
    public void fillingSub() {
        this.uid = super.parseText();
        this.user = super.parseText();
        this.password = super.parseText();
        this.domain = super.parseText();
        this.keepAlive = super.parseInt(4);
        this.random = super.parseHex(8);
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getKeepAlive() {
        return keepAlive;
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getRandom() {
        return random;
    }

    public void setRandom(String random) {
        this.random = random;
    }
}
