package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

import java.util.Date;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 连接后初始化（正式服务器）：端服双向
 * @date 2021/11/410:29
 */
public class X0108_RBaseInit extends ICMD {

    // 秤当前时间
    private Date dtime;

    // 编码格式
    private Character coding;

    // 固件版本
    private String version;

    // SIM卡Id
    private String simId;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.dtime)
                .append(this.coding)
                .append(this.version)
                .append(this.simId);
    }

    @Override
    public void fillingSub() {
        this.dtime = super.parseDate();
        this.coding = super.parseChar();
        this.version = super.parseText();
        this.simId = super.parseText();
    }

    public Date getDtime() {
        return dtime;
    }

    public void setDtime(Date dtime) {
        this.dtime = dtime;
    }

    public Character getCoding() {
        return coding;
    }

    public void setCoding(Character coding) {
        this.coding = coding;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSimId() {
        return simId;
    }

    public void setSimId(String simId) {
        this.simId = simId;
    }
}
