package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

import java.util.Date;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 连接后初始化（正式服务器）：端服双向
 * @date 2021/11/410:29
 */
public class X0108_SBaseInit extends ICMD {

    // 服务器时间
    private Date stime;

    // Fid
    private Integer fided;

    // 功能
    private String funHex;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.stime)
                .append(this.fided, 8)
                .appendHex(this.funHex);
    }

    @Override
    public void fillingSub() {
        this.stime = super.parseDate();
        this.fided = super.parseInt(8);
        this.funHex = super.parseHex(2);
    }

    public Date getStime() {
        return stime;
    }

    public void setStime(Date stime) {
        this.stime = stime;
    }

    public Integer getFided() {
        return fided;
    }

    public void setFided(Integer fided) {
        this.fided = fided;
    }

    public String getFunHex() {
        return funHex;
    }

    public void setFunHex(String funHex) {
        this.funHex = funHex;
    }

    public String gtFided() {
        return this.int2SHex(this.fided, 8);
    }

    public void stFided(String fided) {
        this.fided = this.shex2Int(fided);
    }
}
