package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 5.9 绑定后再分发：端服双向
 * @date 2021/11/410:29
 */
public class X0109_RRetryDelivery extends ICMD {

    // 固件版本
    private String version;

    // 设备名
    private String user;

    // 设备密码
    private String password;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.version)
                .append(this.user)
                .append(this.password);
    }

    @Override
    public void fillingSub() {
        this.version = super.parseText();
        this.user = super.parseText();
        this.password = super.parseText();
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
