package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 5.10 汇报申请：服端简报
 * @date 2021/11/410:29
 */
public class X0140_RReportApply extends ICMD {

    // 汇报类型 0-NULL 1-重量
    private Integer reportType;

    // 汇报周期（秒）端的程序中固有推荐周期，假设端的推荐周期=2秒，则当汇报周期小于2秒时，端根据自己固有的推荐周期执行汇报
    private Integer reportCycle;

    // 汇报有效期（秒）当有效期=0时，代表这是一个一次性汇报；不然在有效期内，端会重复本次汇报。
    private Integer reportInvalid;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.reportType, 4)
                .append(this.reportCycle, 4)
                .append(this.reportInvalid, 4);
    }

    @Override
    public void fillingSub() {
        this.reportType = super.parseInt(4);
        this.reportCycle = super.parseInt(4);
        this.reportInvalid = super.parseInt(4);
    }

    public Integer getReportType() {
        return reportType;
    }

    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    public Integer getReportCycle() {
        return reportCycle;
    }

    public void setReportCycle(Integer reportCycle) {
        this.reportCycle = reportCycle;
    }

    public Integer getReportInvalid() {
        return reportInvalid;
    }

    public void setReportInvalid(Integer reportInvalid) {
        this.reportInvalid = reportInvalid;
    }
}
