package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: BaseModule
 * @projectName meter-jar
 * @description: 5.10 汇报申请：服端简报
 * @date 2021/11/410:29
 */
public class X0140_SReportApply extends ICMD {

    // 汇报类型 0-NULL 1-重量
    private Integer reportType;

    // 结束标志
    private Character endSign;

    // N单位
    private Integer unit;

    // F标志
    private String flag;

    // W重量
    private BigDecimal weight;

    // T皮重
    private BigDecimal tare;

    // U单价
    private BigDecimal unitPrice;

    // P合计
    private BigDecimal totalPrice;

    // S单重
    private BigDecimal singleWeight;

    // C件数
    private BigDecimal pieceCount;

    @Override
    public IMQTT packSubContent() {
        return ((X0140_SReportApply) (super.packSubContent()
                .append(this.reportType, 4)
                .append(this.endSign)
                .append(this.adetailv(), 2)))
                .adetail();
    }

    @Override
    public void fillingSub() {
        this.reportType = super.parseInt(4);
        this.endSign = super.parseChar();
        int detail = super.parseInt(2);
        this.pdetail(detail);
    }

    /**
     * @description: 标志位解析
     **/
    private void pdetail(int detail) {
        this.unit = super.parseInt(2);
        this.flag = super.parseBin(4);
        switch (detail) {
            case 0:
                this.weight = super.parseBigDecimal();
                break;
            case 1:
                this.weight = super.parseBigDecimal();
                this.tare = super.parseBigDecimal();
                break;
            case 2:
                this.weight = super.parseBigDecimal();
                this.unitPrice = super.parseBigDecimal();
                this.totalPrice = super.parseBigDecimal();
                break;
            case 3:
                this.weight = super.parseBigDecimal();
                this.tare = super.parseBigDecimal();
                this.unitPrice = super.parseBigDecimal();
                this.totalPrice = super.parseBigDecimal();
                break;
            case 4:
                this.weight = super.parseBigDecimal();
                this.singleWeight = super.parseBigDecimal();
                this.pieceCount = super.parseBigDecimal();
                break;
            case 5:
                this.weight = super.parseBigDecimal();
                this.tare = super.parseBigDecimal();
                this.singleWeight = super.parseBigDecimal();
                this.pieceCount = super.parseBigDecimal();
                break;
        }
    }

    /**
     * @description:
     **/
    private IMQTT adetail() {
        if (Objects.nonNull(this.unit)) super.append(this.unit, 2);
        if (StringUtils.isNotBlank(this.flag)) super.appendBin(this.flag, 4);
        if (Objects.nonNull(this.weight)) super.append(this.weight);
        if (Objects.nonNull(this.tare)) super.append(this.tare);
        if (Objects.nonNull(this.unitPrice)) super.append(this.unitPrice);
        if (Objects.nonNull(this.totalPrice)) super.append(this.totalPrice);
        if (Objects.nonNull(this.singleWeight)) super.append(this.singleWeight);
        if (Objects.nonNull(this.pieceCount)) super.append(this.pieceCount);
        return this;
    }

    /**
     * @description: 获取标志位
     **/
    public Integer adetailv() {
        StringBuffer buffer = new StringBuffer();
        if (Objects.nonNull(this.unit)) buffer.append("N");
        if (StringUtils.isNotBlank(this.flag)) buffer.append("F");
        if (Objects.nonNull(this.weight)) buffer.append("W");
        if (Objects.nonNull(this.tare)) buffer.append("T");
        if (Objects.nonNull(this.unitPrice)) buffer.append("U");
        if (Objects.nonNull(this.totalPrice)) buffer.append("P");
        if (Objects.nonNull(this.singleWeight)) buffer.append("S");
        if (Objects.nonNull(this.pieceCount)) buffer.append("C");

        int detail = 0;
        switch (buffer.toString()) {
            case "NFW":
                detail = 0;
                break;
            case "NFWT":
                detail = 1;
                break;
            case "NFWUP":
                detail = 2;
                break;
            case "NFWTUP":
                detail = 3;
                break;
            case "NFWSC":
                detail = 4;
                break;
            case "NFWTSC":
                detail = 5;
                break;
        }
        return detail;
    }

    public Integer getReportType() {
        return reportType;
    }

    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    public Character getEndSign() {
        return endSign;
    }

    public void setEndSign(Character endSign) {
        this.endSign = endSign;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public void setTare(BigDecimal tare) {
        this.tare = tare;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getSingleWeight() {
        return singleWeight;
    }

    public void setSingleWeight(BigDecimal singleWeight) {
        this.singleWeight = singleWeight;
    }

    public BigDecimal getPieceCount() {
        return pieceCount;
    }

    public void setPieceCount(BigDecimal pieceCount) {
        this.pieceCount = pieceCount;
    }
}
