package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: X0160_RLbsloc
 * @projectName meter-jar
 * @description: 5.12.1 读取定位信息和信号强度
 * @date 2021/11/2418:56
 */
public class X0160_SLbslocRssis extends ICMD {

    // 经度
    private BigDecimal lng;

    // 维度
    private BigDecimal lat;

    // 信号强度
    private Integer rssis;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.lng)
                .append(this.lat)
                .append(this.rssis, 2);
    }

    @Override
    public void fillingSub() {
        this.lng = super.parseBigDecimal();
        this.lat = super.parseBigDecimal();
        this.rssis = super.parseInt(2);
    }

    public BigDecimal getLng() {
        return lng;
    }

    public void setLng(BigDecimal lng) {
        this.lng = lng;
    }

    public BigDecimal getLat() {
        return lat;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }

    public Integer getRssis() {
        return rssis;
    }

    public void setRssis(Integer rssis) {
        this.rssis = rssis;
    }
}
