package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: X0160_RLbsloc
 * @projectName meter-jar
 * @description: 5.12.5 更新订阅号
 * @date 2021/11/2418:56
 */
public class X0164_RUpdateTopic extends ICMD {

    // 设置订阅号
    private List<Topic> addTopics;

    // 删除订阅号
    private List<Topic> delTopics;

    @Override
    public IMQTT packSubContent() {
        IMQTT imqtt = super.packSubContent()
                .append(this.addTopics == null || this.addTopics.isEmpty() ? 0 : this.addTopics.size(), 2);
        if (this.addTopics != null && !this.addTopics.isEmpty()) {
            for (Topic addTopic : addTopics) {
                imqtt.append(addTopic.getTopic())
                        .append(addTopic.getQos(), 2);
            }
        }

        imqtt.append(this.delTopics == null || this.delTopics.isEmpty() ? 0 : this.delTopics.size(), 2);
        if (this.delTopics != null && !this.delTopics.isEmpty()) {
            for (Topic delTopic : delTopics) {
                imqtt.append(delTopic.getTopic());

            }
        }
        return this;
    }

    @Override
    public void fillingSub() {
        int addCount = super.parseInt(2);
        if (addCount > 0) {
            this.addTopics = new ArrayList<>();
            for (int i = 0; i < addCount; i++) {
                this.addTopics.add(new Topic(super.parseText(), super.parseInt(2)));
            }
        }

        int delCount = super.parseInt(2);
        if (delCount > 0) {
            this.delTopics = new ArrayList<>();
            for (int i = 0; i < delCount; i++) {
                this.delTopics.add(new Topic(super.parseText()));
            }
        }
    }

    public List<Topic> getAddTopics() {
        return addTopics;
    }

    public void setAddTopics(List<Topic> addTopics) {
        this.addTopics = addTopics;
    }

    public List<Topic> getDelTopics() {
        return delTopics;
    }

    public void setDelTopics(List<Topic> delTopics) {
        this.delTopics = delTopics;
    }

    /**
     * @description: 订阅号信息
     **/
    public static class Topic {

        private String topic;

        private Integer qos;

        public Topic() {
        }

        public Topic(String topic) {
            this.topic = topic;
        }

        public Topic(String topic, Integer qos) {
            this.topic = topic;
            this.qos = qos;
        }

        public String getTopic() {
            return topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public Integer getQos() {
            return qos;
        }

        public void setQos(Integer qos) {
            this.qos = qos;
        }
    }
}
