package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

import java.util.Date;

/**
 * @author lie_w
 * @title: X0160_RLbsloc
 * @projectName meter-jar
 * @description: 5.13.6 获取模块时间
 * @date 2021/11/2418:56
 */
public class X0166_SModule_Time extends ICMD {

    // 主板IMEI号
    private String imei;

    // SIM卡ID
    private String simId;

    // 模块时间
    private Date time;

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.imei)
                .append(this.simId)
                .append(this.time);
    }

    @Override
    public void fillingSub() {
        this.imei = super.parseText();
        this.simId = super.parseText();
        this.time = super.parseDate();
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getSimId() {
        return simId;
    }

    public void setSimId(String simId) {
        this.simId = simId;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }
}
