package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

import java.util.Objects;

/**
 * @author lie_w
 * @title: X0169_RLCD_Display
 * @projectName meter-jar
 * @description: lCD显示响应
 * @date 2023/10/1415:21
 */
public class X0169_RLCD_Display extends ICMD {

    // 显示类型 0-退出显示 1-文本显示 2-图文显示 3-QR显示
    private Integer type;

    // 显示业务
    // 0-退出显示 1-文本显示 默认 0
    // 2-图文显示 0-成功 1-失败 2-警告 3-未知
    // 3-QR显示 0-绑定 1-支付
    private Integer action;

    // 显示时间 0-一直显示
    // 不填默认 255s
    private Integer timeout;

    // 文本1
    // 0-退出显示 空
    // 1-文本显示 文本1
    // 2-图文显示 文本
    // 3-QR显示 QR内容
    private String text1;

    // 文本2
    // 0-退出显示 空
    // 1-文本显示 文本2
    // 2-图文显示 空
    // 3-QR显示 QR内容
    private String text2;

    // 文本3
    // 0-退出显示 空
    // 1-文本显示 文本3
    // 2-图文显示 空
    // 3-QR显示 空
    private String text3;

    /**
     * @description: 内容体组装
     **/
    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.getType(), 2)
                .append(this.getAction(), 2)
                .append(this.getTimeout(), 2)
                .append(this.getText1())
                .append(this.getText2())
                .append(this.getText3());
    }

    /**
     * @description: 解析填充
     **/
    @Override
    public void fillingSub() {
        this.action = super.parseInt(2);
        this.action = super.parseInt(2);
        this.timeout = super.parseInt(2);
        this.text1 = super.parseText();
        this.text2 = super.parseText();
        this.text3 = super.parseText();
    }

    public Integer getType() {
        return Objects.nonNull(type) ? type : 0;
    }

    public X0169_RLCD_Display setType(Integer type) {
        this.type = type;
        return this;
    }

    public Integer getAction() {
        return Objects.nonNull(action) ? action : 0;
    }

    public X0169_RLCD_Display setAction(Integer action) {
        this.action = action;
        return this;
    }

    public Integer getTimeout() {
        return Objects.nonNull(timeout) ? timeout : 255;
    }

    public X0169_RLCD_Display setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getText1() {
        return text1;
    }

    public X0169_RLCD_Display setText1(String text1) {
        this.text1 = text1;
        return this;
    }

    public String getText2() {
        return text2;
    }

    public X0169_RLCD_Display setText2(String text2) {
        this.text2 = text2;
        return this;
    }

    public String getText3() {
        return text3;
    }

    public X0169_RLCD_Display setText3(String text3) {
        this.text3 = text3;
        return this;
    }
}
