package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;
import com.jhscale.meter.mqtt.entity.SensorInfo;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: X0400_RObtian_Sensor
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/2818:10
 */
public class X0400_SObtian_Sensor extends ICMD {

    // 传感器
    private List<SensorInfo> sensors;

    @Override
    public IMQTT packSubContent() {
        IMQTT imqtt = super.packSubContent()
                .append(sensors.size(), 2);
        sensors.forEach(sensor -> {
            imqtt.append(sensor.getIndex(), 2)
                    .append(sensor.getAddress(), 2)
                    .appendCovert(sensor.getInner())
                    .appendCovert(sensor.getCoefficient());
        });
        return imqtt;
    }

    @Override
    public void fillingSub() {
        int size = super.parseInt(2);
        for (int i = 0; i < size; i++) {
            SensorInfo sensor = new SensorInfo();
            sensor.setIndex(super.parseInt(2));
            sensor.setAddress(super.parseInt(2));
            sensor.setInner(super.parseCovert(8));
            sensor.setCoefficient(super.parseCovert(8));
            this.addSensors(sensor);
        }
    }

    public List<SensorInfo> getSensors() {
        return sensors;
    }

    public void setSensors(List<SensorInfo> sensors) {
        this.sensors = sensors;
    }

    /**
     * @description: 添加传感器
     **/
    public void addSensors(SensorInfo sensor) {
        if (this.sensors == null) this.sensors = new ArrayList<>();
        this.sensors.add(sensor);
    }
}
