package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;
import com.jhscale.meter.mqtt.entity.UniqueSensor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: X0400_RObtian_Sensor
 * @projectName meter-jar
 * @description: 5.14.2 绑定成功上传绑定终端需要保存信息
 * @date 2021/12/2818:10
 */
public class X0401_RBind extends ICMD {

    // 传感器
    private List<UniqueSensor> sensors;

    // 用户
    private String user;

    @Override
    public IMQTT packSubContent() {
        IMQTT imqtt = super.packSubContent()
                .append(sensors.size(), 2);
        sensors.forEach(sensor -> {
            imqtt.append(sensor.getIndex(), 2)
                    .append(sensor.getAddress(), 2)
                    .appendCovert(sensor.getUnique());
        });
        imqtt.append(this.user);
        return imqtt;
    }

    @Override
    public void fillingSub() {
        int size = super.parseInt(2);
        for (int i = 0; i < size; i++) {
            this.addSensors(new UniqueSensor(this));
        }
        this.user = super.parseText();
    }

    public List<UniqueSensor> getSensors() {
        return sensors;
    }

    public void setSensors(List<UniqueSensor> sensors) {
        this.sensors = sensors;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    /**
     * @description: 添加传感器
     **/
    public void addSensors(UniqueSensor sensor) {
        if (this.sensors == null) this.sensors = new ArrayList<>();
        this.sensors.add(sensor);
    }
}
