package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: X0400_RObtian_Sensor
 * @projectName meter-jar
 * @description: 支付申请
 * @date 2021/12/2818:10
 */
public class X0404_RPay_Apply extends ICMD {

    // 日志编号
    private int fid;

    // 单位
    private int unit;

    // 重量
    private BigDecimal weight;

    // 重复次数
    private int repeatNumber;

    /**
     * @description: 内容体组装
     **/
    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.fid, 8)
                .append(this.unit, 2)
                .append(this.weight)
                .append(this.repeatNumber, 2);
    }

    /**
     * @description: 解析填充
     **/
    @Override
    public void fillingSub() {
        this.fid = super.parseInt(8);
        this.unit = super.parseInt(2);
        this.weight = super.parseBigDecimal();
        this.repeatNumber = super.parseInt(2);
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getUnit() {
        return unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public int getRepeatNumber() {
        return repeatNumber;
    }

    public void setRepeatNumber(int repeatNumber) {
        this.repeatNumber = repeatNumber;
    }
}
