package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;
import org.apache.commons.lang3.StringUtils;

import static com.jhscale.meter.mqtt.MQTTConstant.PAY_WAY_ALL;

/**
 * @author lie_w
 * @title: X0400_RObtian_Sensor
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/2818:10
 */
public class X0404_SPay_Apply extends ICMD {

    // 日志编号
    private int fid;

    // 订单编号
    private String no;

    // 订单支付码
    private String qr;

    // 标题
    private String title;

    // 支持渠道
    private String payway;

    /**
     * @description: 内容体组装
     **/
    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.fid, 8)
                .append(this.no)
                .append(this.qr)
                .append(this.title)
                .appendHex(this.getPayway());
    }

    /**
     * @description: 解析填充
     **/
    @Override
    public void fillingSub() {
        this.fid = super.parseInt(8);
        this.no = super.parseText();
        this.qr = super.parseText();
        this.title = super.parseText();
        this.payway = super.parseHex(2);
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getNo() {
        return no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public String getQr() {
        return qr;
    }

    public void setQr(String qr) {
        this.qr = qr;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPayway() {
        return StringUtils.isNotBlank(this.payway) ? this.payway : PAY_WAY_ALL;
    }

    public void setPayway(String payway) {
        this.payway = payway;
    }
}
