package com.jhscale.meter.mqtt.cmd;

import com.jhscale.meter.mqtt.ICMD;
import com.jhscale.meter.mqtt.IMQTT;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author lie_w
 * @title: X0400_RObtian_Sensor
 * @projectName meter-jar
 * @description: 支付申请
 * @date 2021/12/2818:10
 */
public class X0406_ROrder_Print extends ICMD {

    // 日志编号
    private int fid;

    // 订单编号
    private String no;

    // 标题信息
    private String title;

    // 第三方单号
    private String svpnno;

    // 重量信息
    private BigDecimal weight;

    // 支付金额(分)
    private BigDecimal money;

    // 支付方式
    private int payType;

    // 车牌号
    private String car;

    // 完成时间
    private Date finishTime;

    /**
     * @description: 内容体组装
     **/
    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(this.fid, 8)
                .append(this.title)
                .append(this.no)
                .append(this.svpnno)
                .append(this.weight)
                .append(this.money)
                .append(this.payType, 2)
                .append(this.car)
                .append(this.finishTime());
    }

    /**
     * @description: 解析填充
     **/
    @Override
    public void fillingSub() {
        this.fid = super.parseInt(8);
        this.title = super.parseText();
        this.no = super.parseText();
        this.svpnno = super.parseText();
        this.weight = super.parseBigDecimal();
        this.money = super.parseBigDecimal();
        this.payType = super.parseInt(2);
        this.car = super.parseText();
        this.finishTime = super.parseDate();
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNo() {
        return no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public String getSvpnno() {
        return svpnno;
    }

    public void setSvpnno(String svpnno) {
        this.svpnno = svpnno;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public int getPayType() {
        return payType;
    }

    public void setPayType(int payType) {
        this.payType = payType;
    }

    public String getCar() {
        return car;
    }

    public void setCar(String car) {
        this.car = car;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public Date finishTime() {
        return Objects.nonNull(this.finishTime) ? this.finishTime : new Date();
    }
}
