package com.jhscale.meter.mqtt.data;

import com.jhscale.meter.mqtt.IDATA;
import com.jhscale.meter.mqtt.IMQTT;
import com.jhscale.meter.mqtt.em.DCmd;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MQTTUtils;

/**
 * @author lie_w
 * @title: TruckData
 * @projectName meter-jar
 * @description: 汽车衡数据流
 * @date 2021/12/2112:28
 */
public class TruckData extends IDATA {

    // 内容
    private String data;

    /**
     * @description: 组装构造函数
     **/
    public TruckData() {
    }

    public TruckData(DCmd cmd, Integer did) {
        super(cmd, did);
    }

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .appendHex(this.data);
    }

    @Override
    public void fillingSub() {
        this.data = super.parseHex();
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Integer obtainData() {
        return MQTTUtils.hex2Int(ByteUtils.convert(this.data));
    }

    public void addData(Integer did) {
        this.data = ByteUtils.convert(MQTTUtils.int2Hex(did));
    }
}
