package com.jhscale.meter.mqtt.data;

import com.jhscale.meter.mqtt.IDATA;
import com.jhscale.meter.mqtt.IMQTT;
import com.jhscale.meter.mqtt.annotations.COrder;
import com.jhscale.meter.mqtt.em.DCmd;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Date;

/**
 * @author lie_w
 * @title: TruckData
 * @projectName meter-jar
 * @description: 汽车衡日志
 * @date 2021/12/2112:28
 */
public class TruckLog extends IDATA {

    // 日志时间
    private Date date;

    // 日志类型
    // 0:正常F8[浮动0-4]
    // 100:超重错误014001[浮动字段22{超重数数值}]
    // 101:传感器错误014008[浮动字段19{传感器错误编号}]
    // 102:仪表错误014001[浮动字段22{错误编号}]
    private Integer type;

    @COrder(order = 1, description = "PLUNO 货号")
    private Integer pluNo;

    @COrder(order = 2, description = "汽车车号")
    private Integer carNo;

    @COrder(order = 3, description = "单位")
    private Integer unit;

    @COrder(order = 4, description = "毛重")
    private BigDecimal gross;

    @COrder(order = 5, description = "皮重")
    private BigDecimal tare;

    @COrder(order = 6, description = "本次称重")
    private BigDecimal weight;

    @COrder(order = 7, description = "上次称重关联Fid")
    private Integer codid;

    @COrder(order = 8, description = "上次称重关联其他设备")
    private String couid;

    @COrder(order = 9, description = "货品名")
    private String pluName;

    @COrder(order = 10, description = "确认车牌号")
    private String carNum;

    @COrder(order = 11, description = "进出标志 0-进场 1-出场")
    private Integer inOut;

    @COrder(order = 12, description = "进出场图片 ； 间隔")
    private String inOutPic;

    @COrder(order = 13, description = "进出场车牌号 ; 间隔")
    private String inOutCarNum;

    @COrder(order = 14, description = "进出场车牌号图片 ;")
    private String inOutCarNumPic;

    @COrder(order = 15, description = "进出场备注")
    private String remark;

    @COrder(order = 16, description = "设备错误状态")
    private String errState;

    @COrder(order = 17, description = "支付方式 默认：0\n" +
            "0-无需支付\n" +
            "1-支付宝\n" +
            "2-微信\n" +
            "3-现金\n" +
            "4-月结\n" +
            "5-其他\n")
    private Integer payType;

    @COrder(order = 18, description = "支付金额")
    private BigDecimal payMoney;

    @COrder(order = 19, description = "支付策略")
    private Integer payStrategy;

    @COrder(order = 20, description = "传感器错误 6*2[0xFFFF] 默认 0000 0000 0000 0000\n" +
            "0000 0000\n" +
            "0-\tADC硬件错误\n" +
            "1-\tDSC连接错误\n" +
            "2-\tSER配置错误\n" +
            "3-\tOVF超重错误\n" +
            "4-\t加密错误\n" +
            "5-\t锁定错误\n")
    private String sensorError;

    @COrder(order = 21, description = "错误文本1/描述文本1")
    private String errText1;

    @COrder(order = 22, description = "错误文本2/描述文本2")
    private String errText2;

    @COrder(order = 23, description = "错误数值1/错误编号1")
    private BigDecimal errNum1;

    @COrder(order = 24, description = "错误数值2/错误编号2")
    private BigDecimal errNum2;

    @COrder(order = 25, description = "文本1")
    private String text1;

    @COrder(order = 26, description = "文本2")
    private String text2;

    @COrder(order = 27, description = "文本3")
    private String text3;

    @COrder(order = 28, description = "文本4")
    private String text4;

    /**
     * @description: 组装构造函数
     **/
    public TruckLog() {
    }

    public TruckLog(DCmd cmd, Integer did) {
        super(cmd, did);
    }

    public TruckLog(Charset charset, DCmd cmd, Integer did) {
        super(charset, cmd, did);
    }

    @Override
    public IMQTT packSubContent() {
        return super.packSubContent()
                .append(date)
                .append(this.type, 2)
                .appendFloat()
                .append(this.pluNo, 8)
                .append(this.carNo, 8)
                .append(this.unit, 2)
                .appendNull(this.gross)
                .appendNull(this.tare)
                .appendNull(this.weight)
                .append(this.codid, 8)
                .appendNull(this.couid)
                .appendNull(this.pluName)
                .appendNull(this.carNum)
                .append(this.inOut, 2)
                .appendNull(this.inOutPic)
                .appendNull(this.inOutCarNum)
                .appendNull(this.inOutCarNumPic)
                .appendNull(this.remark)
                .appendNull(this.errState)
                .append(this.payType, 2)
                .appendNull(this.payMoney)
                .append(this.payStrategy, 2)
                .appendHex(this.sensorError)
                .appendNull(this.errText1)
                .appendNull(this.errText2)
                .appendNull(this.errNum1)
                .appendNull(this.errNum2)
                .appendNull(this.text1)
                .appendNull(this.text2)
                .appendNull(this.text3)
                .appendNull(this.text4);
    }

    @Override
    public void fillingSub() {
        this.date = super.parseDate();
        this.type = super.parseInt(2);
        char[] chars = super.parseFloat();
        if (chars[0] == '1') this.pluNo = super.parseInt(8);
        if (chars[1] == '1') this.carNo = super.parseInt(8);
        if (chars[2] == '1') this.unit = super.parseInt(2);
        if (chars[3] == '1') this.gross = super.parseBigDecimal();
        if (chars[4] == '1') this.tare = super.parseBigDecimal();
        if (chars[5] == '1') this.weight = super.parseBigDecimal();
        if (chars[6] == '1') this.codid = super.parseInt(8);
        if (chars[16] == '1') this.couid = super.parseText();
        if (chars[17] == '1') this.pluName = super.parseText();
        if (chars[18] == '1') this.carNum = super.parseText();
        if (chars[19] == '1') this.inOut = super.parseInt(2);
        if (chars[20] == '1') this.inOutPic = super.parseText();
        if (chars[21] == '1') this.inOutCarNum = super.parseText();
        if (chars[22] == '1') this.inOutCarNumPic = super.parseText();
        if (chars[23] == '1') this.remark = super.parseText();
        if (chars[24] == '1') this.errState = super.parseText();
        if (chars[25] == '1') this.payType = super.parseInt(2);
        if (chars[26] == '1') this.payMoney = super.parseBigDecimal();
        if (chars[27] == '1') this.payStrategy = super.parseInt(2);
        if (chars[28] == '1') this.sensorError = super.parseHex(24);
        if (chars[29] == '1') this.errText1 = super.parseText();
        if (chars[30] == '1') this.errText2 = super.parseText();
        if (chars[31] == '1') this.errNum1 = super.parseBigDecimal();
        if (chars[32] == '1') this.errNum2 = super.parseBigDecimal();
        if (chars[33] == '1') this.text1 = super.parseText();
        if (chars[34] == '1') this.text2 = super.parseText();
        if (chars[35] == '1') this.text3 = super.parseText();
        if (chars[36] == '1') this.text4 = super.parseText();
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getPluNo() {
        return pluNo;
    }

    public void setPluNo(Integer pluNo) {
        this.pluNo = pluNo;
    }

    public Integer getCarNo() {
        return carNo;
    }

    public void setCarNo(Integer carNo) {
        this.carNo = carNo;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public BigDecimal getGross() {
        return gross;
    }

    public void setGross(BigDecimal gross) {
        this.gross = gross;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public void setTare(BigDecimal tare) {
        this.tare = tare;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public Integer getCodid() {
        return codid;
    }

    public void setCodid(Integer codid) {
        this.codid = codid;
    }

    public String getCouid() {
        return couid;
    }

    public void setCouid(String couid) {
        this.couid = couid;
    }

    public String getPluName() {
        return pluName;
    }

    public void setPluName(String pluName) {
        this.pluName = pluName;
    }

    public String getCarNum() {
        return carNum;
    }

    public void setCarNum(String carNum) {
        this.carNum = carNum;
    }

    public Integer getInOut() {
        return inOut;
    }

    public void setInOut(Integer inOut) {
        this.inOut = inOut;
    }

    public String getInOutPic() {
        return inOutPic;
    }

    public void setInOutPic(String inOutPic) {
        this.inOutPic = inOutPic;
    }

    public String getInOutCarNum() {
        return inOutCarNum;
    }

    public void setInOutCarNum(String inOutCarNum) {
        this.inOutCarNum = inOutCarNum;
    }

    public String getInOutCarNumPic() {
        return inOutCarNumPic;
    }

    public void setInOutCarNumPic(String inOutCarNumPic) {
        this.inOutCarNumPic = inOutCarNumPic;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getErrState() {
        return errState;
    }

    public void setErrState(String errState) {
        this.errState = errState;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public BigDecimal getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(BigDecimal payMoney) {
        this.payMoney = payMoney;
    }

    public Integer getPayStrategy() {
        return payStrategy;
    }

    public void setPayStrategy(Integer payStrategy) {
        this.payStrategy = payStrategy;
    }

    public String getSensorError() {
        return sensorError;
    }

    public void setSensorError(String sensorError) {
        this.sensorError = sensorError;
    }

    public String getErrText1() {
        return errText1;
    }

    public void setErrText1(String errText1) {
        this.errText1 = errText1;
    }

    public String getErrText2() {
        return errText2;
    }

    public void setErrText2(String errText2) {
        this.errText2 = errText2;
    }

    public BigDecimal getErrNum1() {
        return errNum1;
    }

    public void setErrNum1(BigDecimal errNum1) {
        this.errNum1 = errNum1;
    }

    public BigDecimal getErrNum2() {
        return errNum2;
    }

    public void setErrNum2(BigDecimal errNum2) {
        this.errNum2 = errNum2;
    }

    public String getText1() {
        return text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public String getText2() {
        return text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public String getText3() {
        return text3;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    public String getText4() {
        return text4;
    }

    public void setText4(String text4) {
        this.text4 = text4;
    }
}
