package com.jhscale.meter.mqtt.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: ACK
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/523:33
 */
public enum ACK {

    Request("0", true, "发送"),
    Response("1", false, "应答");

    private String bit;

    private boolean request;

    private String description;

    ACK(String bit, boolean request, String description) {
        this.bit = bit;
        this.request = request;
        this.description = description;
    }

    /**
     * @description: 获取ACK
     **/
    public static ACK bit(String bit) {
        if (StringUtils.isNotBlank(bit)) {
            for (ACK ack : ACK.values()) {
                if (bit.equals(ack.getBit())) return ack;
            }
        }
        return null;
    }

    public String getBit() {
        return bit;
    }

    public boolean isRequest() {
        return request;
    }

    public String getDescription() {
        return description;
    }
}
