package com.jhscale.meter.mqtt.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: CD
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/110:43
 */
public enum CD {

    MODULE(0, "00", "模块命令"),
    CMD(1, "01", "命令 CMD"),
    DATA(2, "10", "服务器数据流"),
    API(3, "11", "API数据流"),;

    private Integer val;

    private String bit;

    private String description;

    CD(Integer val, String bit, String description) {
        this.val = val;
        this.bit = bit;
        this.description = description;
    }

    /**
     * @description: 获取CD
     **/
    public static CD val(Integer val) {
        if (Objects.nonNull(val)) {
            for (CD cd : CD.values()) {
                if (val.equals(cd.getVal())) return cd;
            }
        }
        return null;
    }

    /**
     * @description: 获取CD
     **/
    public static CD bit(String bit) {
        if (StringUtils.isNotBlank(bit)) {
            for (CD cd : CD.values()) {
                if (bit.equals(cd.getBit())) return cd;
            }
        }
        return null;
    }

    public Integer getVal() {
        return val;
    }

    public String getBit() {
        return bit;
    }

    public String getDescription() {
        return description;
    }
}
