package com.jhscale.meter.mqtt.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ACK
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/110:38
 */
public enum Confirm {

    NWAIT(0, "00", "发送不期待确认"),
    WAIT(1, "01", "发送并期待确认"),
    SUCCESS(2, "10", "应答：成功"),
    FAIL(3, "11", "应答：失败"),;

    private Integer val;

    private String bit;

    private String description;

    Confirm(Integer val, String bit, String description) {
        this.val = val;
        this.bit = bit;
        this.description = description;
    }

    /**
     * @description: 获取ACK
     **/
    public static Confirm val(Integer val) {
        if (Objects.nonNull(val)) {
            for (Confirm confirm : Confirm.values()) {
                if (val.equals(confirm.getVal())) return confirm;
            }
        }
        return null;
    }

    /**
     * @description: 获取ACK
     **/
    public static Confirm bit(String bit) {
        if (StringUtils.isNotBlank(bit)) {
            for (Confirm confirm : Confirm.values()) {
                if (bit.equals(confirm.getBit())) return confirm;
            }
        }
        return null;
    }

    public Integer getVal() {
        return val;
    }

    public String getBit() {
        return bit;
    }

    public String getDescription() {
        return description;
    }

}
