package com.jhscale.meter.mqtt.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: DCmd
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/2115:51
 */
public enum DCmd {

    SEND("11", "发送指令"),
    DELETE("10", "删除指令"),
    REQUEST("01", "请求指令");

    private String cmd;

    private String description;

    DCmd(String cmd, String description) {
        this.cmd = cmd;
        this.description = description;
    }

    public static DCmd cmd(String cmd) {
        if (StringUtils.isNotBlank(cmd)) {
            for (DCmd dCmd : DCmd.values()) {
                if (dCmd.getCmd().equals(cmd)) return dCmd;
            }
        }
        return null;
    }

    public String getCmd() {
        return cmd;
    }

    public String getDescription() {
        return description;
    }
}
