package com.jhscale.meter.mqtt.em;

import com.jhscale.meter.mqtt.data.TruckData;
import com.jhscale.meter.mqtt.data.TruckLog;
import com.jhscale.test.mqtt.entity.TestData;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: DSort
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/2112:32
 */
public enum DSort {

    汽车衡日志("0200", "汽车衡日志", TruckLog.class),
    汽车衡数据参数("0201", "汽车衡数据参数", TruckData.class),


    /**
     * @description: 测试部分
     **/
    测试0101("0101", "测试", TestData.class),
    测试00("00", "测试", TestData.class),
    ;

    private String sort;

    private String description;

    private Class clazz;

    DSort(String sort, String description, Class clazz) {
        this.sort = sort;
        this.description = description;
        this.clazz = clazz;
    }

    /**
     * @description: 获取SORT
     **/
    public static DSort sort(String sort) {
        if (StringUtils.isNotBlank(sort)) {
            for (DSort dSort : DSort.values()) {
                if (dSort.getSort().equals(sort)) return dSort;
            }
        }
        return null;
    }

    /**
     * @description: 获取SORT
     **/
    public static DSort sort(Class clazz) {
        if (Objects.nonNull(clazz)) {
            for (DSort dSort : DSort.values()) {
                if (clazz.equals(dSort.getClazz()))
                    return dSort;
            }
        }
        return null;
    }

    public String getSort() {
        return sort;
    }

    public String getDescription() {
        return description;
    }

    public Class getClazz() {
        return clazz;
    }
}
