package com.jhscale.meter.mqtt.em;

import org.apache.commons.lang3.StringUtils;

import java.nio.charset.Charset;

/**
 * @author lie_w
 * @title: Encoding
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/22:03
 */
public enum Encoding {
    GBK("C", "GBK"),
    UTF_8("U", "UTF-8"),
    GB2312("G", "GB2312");

    private String coding;

    private String encoding;

    Encoding(String coding, String encoding) {
        this.coding = coding;
        this.encoding = encoding;
    }

    /**
     * @description: 字符标志
     **/
    public static Encoding coding(String coding) {
        if (StringUtils.isNotBlank(coding)) {
            for (Encoding encoding : Encoding.values()) {
                if (coding.equals(encoding.getCoding())) return encoding;
            }
        }
        return Encoding.GBK;
    }

    public String getCoding() {
        return coding;
    }

    public String getEncoding() {
        return encoding;
    }

    public Charset getCharset() {
        return Charset.forName(getEncoding());
    }
}
