package com.jhscale.meter.mqtt.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: Encrypt
 * @projectName meter-jar
 * @description: 加解密
 * @date 2021/11/1821:22
 */
public enum Encrypt {

    Not_Encrypt("0", false, "不加密"),
    AES_Encrypt("1", true, "AES加密");

    private String bit;

    private boolean encrypt;

    private String description;

    Encrypt(String bit, boolean encrypt, String description) {
        this.bit = bit;
        this.encrypt = encrypt;
        this.description = description;
    }

    /**
     * @description: 获取ACK
     **/
    public static Encrypt bit(String bit) {
        if (StringUtils.isNotBlank(bit)) {
            for (Encrypt encrypt : Encrypt.values()) {
                if (bit.equals(encrypt.getBit())) return encrypt;
            }
        }
        return null;
    }

    public String getBit() {
        return bit;
    }

    public boolean isEncrypt() {
        return encrypt;
    }

    public String getDescription() {
        return description;
    }
}
