package com.jhscale.meter.mqtt.em;

import com.jhscale.meter.mqtt.cmd.*;
import com.jhscale.test.mqtt.entity.TestCommand1Request;
import com.jhscale.test.mqtt.entity.TestCommand1Response;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: MQTTCMD
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/117:34
 */
public enum MQTTCMD {

    X0100_read_module("0100", "读取模块信息", X0100_RReadModule.class, X0100_SReadModule.class),
    X0101_mqtt_break("0101", "MQTT断开连接", X0101_RMQTTBreak.class, X0101_SMQTTBreak.class),
    X0104_mqtt_link("0104", "MQTT连接", X0104_RMQTTLink.class, X0104_SMQTTLink.class),
    X0105_mqtt_status("0105", "MQTT状态", X0105_RMQTTStatus.class, X0105_SMQTTStatus.class),
    X0106_bind1("0106", "绑定连接1", X0106_RBind1.class, X0106_SBind1.class),
    X0107_bind2("0107", "绑定连接2", X0107_RBind2.class, X0107_SBind2.class),
    X0108_base_init("0108", "连接后初始化（基础）", X0108_RBaseInit.class, X0108_SBaseInit.class),
    @Deprecated
    X0109_retry_delivery("0109", "绑定后再分发", X0109_RRetryDelivery.class, X0109_SRetryDelivery.class),
    X010A_bind_notify("010A", "绑定状态通知", X010A_RBindNotify.class, X010A_SBindNotify.class),
    X010B_unbind("010B", "设备解绑", X010B_RUnbind.class, X010B_SUnbind.class),

    /**
     * @description: 汇报
     **/
    X0140_report_apply("0140", "汇报申请", X0140_RReportApply.class, X0140_SReportApply.class),

    /**
     * @description: 0X0160~0X019F 模块指令
     **/
    X0160_read_lbsloc_rssis("0160", "读取定位信息+信号强度", X0160_RLbslocRssis.class, X0160_SLbslocRssis.class),
    X0161_read_siminfo("0161", "读取sim卡信息", X0161_RSimInfo.class, X0161_SSimInfo.class),
    X0162_restart_system("0162", "重启系统", X0162_RRestartSystem.class, X0162_SRestartSystem.class),
    X0163_reset_uart("0163", "重置串口连接", X0163_RSetUart.class, X0163_SSetUart.class),
    X0164_update_topic("0164", "设置订阅号", X0164_RUpdateTopic.class, X0164_SUpdateTopic.class),
    X0165_module_notify("0165", "模端通知", X0165_RModule_Notify.class, X0165_SModule_Notify.class),
    X0166_module_time("0166", "模端时间", X0166_RModule_Time.class, X0166_SModule_Time.class),
    X0167_module_heart("0167", "模块心跳", X0167_RModule_Heart.class, X0167_SModule_Heart.class),
    X0168_module_subscribe("0168", "模块订阅", X0168_RModule_Subscribe.class, X0168_SModule_Subscribe.class),
    X0169_lcd_display("0169", "LCD显示", X0169_RLCD_Display.class, X0169_SLCD_Display.class),

    /**
     * @description: 汽车衡指令
     **/
    X0400_obtain_sensor("0400", "获取传感器信息", X0400_RObtian_Sensor.class, X0400_SObtian_Sensor.class),
    X0401_bind("0401", "汽车衡绑定参数", X0401_RBind.class, X0401_SBind.class),
    X0402_init("0402", "汽车衡初始化检查", X0402_RInit.class, X0402_SInit.class),
    X0403_sensor_modify("0403", "汽车衡传感器变更", X0403_RSensor_Modify.class, X0403_SSensor_Modify.class),
    X0404_pay_apply("0404", "支付申请", X0404_RPay_Apply.class, X0404_SPay_Apply.class),
    X0405_pay_result("0405", "支付结果", X0405_RPay_Result.class, X0405_SPay_Result.class),
    X0406_order_print("0406", "订单打印", X0406_ROrder_Print.class, X0406_SOrder_Print.class),

    /**
     * @description: 测试指令
     **/
    X9999_test_command1("9999", "测试1指令", TestCommand1Request.class, TestCommand1Response.class),
    ;

    private String cmd;

    private String description;

    private Class requestClazz;

    private Class responseClazz;

    MQTTCMD(String cmd, String description, Class requestClazz, Class responseClazz) {
        this.cmd = cmd;
        this.description = description;
        this.requestClazz = requestClazz;
        this.responseClazz = responseClazz;
    }

    /**
     * @description: 获取命令
     **/
    public static MQTTCMD mqttcmd(String cmd) {
        if (StringUtils.isNotBlank(cmd)) {
            for (MQTTCMD mqttcmd : MQTTCMD.values()) {
                if (cmd.equals(mqttcmd.getCmd())) return mqttcmd;
            }
        }
        return null;
    }

    /**
     * @description: 获取指令
     **/
    public static MQTTCMD mqttcmd(Class clazz) {
        if (Objects.nonNull(clazz)) {
            for (MQTTCMD mqttcmd : MQTTCMD.values()) {
                if (clazz.equals(mqttcmd.getRequestClazz()) || clazz.equals(mqttcmd.getResponseClazz()))
                    return mqttcmd;
            }
        }
        return null;
    }

    public String getCmd() {
        return cmd;
    }

    public String getDescription() {
        return description;
    }

    public Class getRequestClazz() {
        return requestClazz;
    }

    public Class getResponseClazz() {
        return responseClazz;
    }
}
