package com.jhscale.meter.mqtt.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: RxStatus
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/2119:18
 */
public enum RxStatus {

    SUCCESS(0, "00", "数据正确"),
    CRC_ERROR(1, "01", "数据正确"),
    DATA_STREAM_ILLEGAL(2, "02", "存在不合法流格式"),
    DSORT_ILLEGAL(3, "03", "存在DSort不被接受"),
    DID_ILLEGAL(4, "04", "存在D-ID不被接受"),
    DDATA_ILLEGAL(5, "05", "存在D-Data不被接受"),
    BUSY(6, "06", "秤忙碌中，不接受新指令"),;

    private Integer status;

    private String hex;

    private String description;

    RxStatus(Integer status, String hex, String description) {
        this.status = status;
        this.hex = hex;
        this.description = description;
    }

    /**
     * @description: 数据流结果
     **/
    public static RxStatus status(Integer status) {
        if (Objects.nonNull(status)) {
            for (RxStatus rxStatus : RxStatus.values()) {
                if (rxStatus.getStatus().equals(status)) return rxStatus;
            }
        }
        return null;
    }

    /**
     * @description: 数据流结果
     **/
    public static RxStatus status(String status) {
        if (StringUtils.isNotBlank(status)) {
            for (RxStatus rxStatus : RxStatus.values()) {
                if (status.equals(rxStatus.getHex())) return rxStatus;
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public String getHex() {
        return hex;
    }

    public String getDescription() {
        return description;
    }
}
