package com.jhscale.meter.mqtt.em;

import java.util.Objects;

/**
 * @author lie_w
 * @title: SensorLockType
 * @projectName ysscale_core
 * @description: 传感器锁定枚举
 * @date 2021/12/3123:33
 */
public enum SensorLock {

    LOCK(0, "传感器锁定状态"),
    HARDWARE(1, "硬件锁定传感器"),
    LINK(2, "连接锁定传感器"),
    CONFIG(3, "配置锁定传感器"),
    OVF(4, "超重锁定传感器"),;

    private Integer type;

    private String description;


    SensorLock(Integer type, String description) {
        this.type = type;
        this.description = description;
    }

    /**
     * @description: 传感器锁定查询
     **/
    public static SensorLock lock(Integer type) {
        if (Objects.nonNull(type)) {
            for (SensorLock sensorLock : SensorLock.values()) {
                if (type.equals(sensorLock.getType())) return sensorLock;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }
}
