package com.jhscale.meter.mqtt.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.mqtt.em.Encoding;
import org.apache.commons.lang3.StringUtils;

import java.nio.charset.Charset;
import java.util.Objects;

/**
 * @author lie_w
 * @title: Equipment
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/12/10:27
 */
public class MQTTClient extends JSONModel {

    // 通讯标识
    private Integer nid = 0;

    // 终端识别号
    private String uid;

    // 设备密钥
    private String key;

    // 字符集
    private Charset charset = Encoding.GBK.getCharset();

    public MQTTClient() {
    }

    public MQTTClient appendNid(Integer nid) {
        this.nid = nid;
        return this;
    }

    public MQTTClient appendUid(String uid) {
        this.uid = uid;
        return this;
    }

    public MQTTClient appendKey(String key) {
        this.key = key;
        return this;
    }

    public MQTTClient appendEncoding(Encoding encoding) {
        this.charset = encoding.getCharset();
        return this;
    }

    public MQTTClient appendEncoding(String coding) {
        this.charset = StringUtils.isBlank(coding) ? Encoding.GBK.getCharset() : Encoding.coding(coding).getCharset();
        return this;
    }

    public MQTTClient appendModule(ModuleInfo moduleInfo) {
        return this.appendEncoding(moduleInfo.getCoding())
                .appendKey(moduleInfo.getKey());
    }

    public MQTTClient appendEncoding(Charset charset) {
        this.charset = Objects.nonNull(charset) ? charset : Encoding.GBK.getCharset();
        return this;
    }

    public Integer getNid() {
        return nid;
    }

    public void setNid(Integer nid) {
        this.nid = nid;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Charset getCharset() {
        return charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}
