package com.jhscale.meter.mqtt.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.mqtt.em.ACK;
import com.jhscale.meter.mqtt.em.CD;
import com.jhscale.meter.mqtt.em.Confirm;
import com.jhscale.meter.mqtt.em.Encrypt;
import com.jhscale.meter.utils.MQTTUtils;

/**
 * @author lie_w
 * @title: Mark
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/11/110:50
 */
public class Mark extends JSONModel {

    // 二进制标识
    private String bin;
    // 加密状态
    private Encrypt encrypt;
    // 请求响应标志
    private ACK ack;
    // 请求响应状态
    private Confirm confirm;
    // 指令标识
    private CD cd;
    // 内容长度
    private int len;

    public Mark() {
    }

    /**
     * @description: 默认不加密
     **/
    public Mark(ACK ack, Confirm confirm, CD cd) {
        this(Encrypt.Not_Encrypt, ack, confirm, cd);
    }

    public Mark(Encrypt encrypt, ACK ack, Confirm confirm, CD cd) {
        this.encrypt = encrypt;
        this.ack = ack;
        this.confirm = confirm;
        this.cd = cd;
    }

    public Mark(String markContent) {
        this.bin = MQTTUtils.hex2Bit(markContent);
        this.encrypt = Encrypt.bit(this.bin.substring(0, 1));
        this.ack = ACK.bit(this.bin.substring(1, 2));
        this.confirm = Confirm.bit(this.bin.substring(2, 4));
        this.cd = CD.bit(this.bin.substring(4, 6));
        this.len = MQTTUtils.bit2Int(this.bin.substring(6, 8)) * 2;
    }

    /**
     * @description: 组装Mark
     **/
    public String assembleMark() {
        String bin = new StringBuffer()
                .append(this.encrypt.getBit())
                .append(this.ack.getBit())
                .append(this.confirm.getBit())
                .append(this.cd.getBit())
                .append(MQTTUtils.int2Bit(this.len / 2))
                .toString();
        this.bin = bin;
        return MQTTUtils.bit2Hex(bin);
    }

    public String getBin() {
        return bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public Encrypt getEncrypt() {
        return encrypt;
    }

    public void setEncrypt(Encrypt encrypt) {
        this.encrypt = encrypt;
    }

    public ACK getAck() {
        return ack;
    }

    public void setAck(ACK ack) {
        this.ack = ack;
    }

    public Confirm getConfirm() {
        return confirm;
    }

    public void setConfirm(Confirm confirm) {
        this.confirm = confirm;
    }

    public CD getCd() {
        return cd;
    }

    public void setCd(CD cd) {
        this.cd = cd;
    }

    public int getLen() {
        return len;
    }

    public void setLen(int len) {
        this.len = len;
    }
}
