package com.jhscale.meter.mqtt.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.meter.mqtt.IMQTT;

/**
 * @author lie_w
 * @title: TruckSensor
 * @projectName meter-jar
 * @description: 汽车衡传感器
 * @date 2021/12/2818:11
 */
public class UniqueSensor extends JSONModel {

    // 传感器角标
    private Integer index;

    // 传感器地址
    private Integer address;

    // 传感器唯一码
    private String unique;

    public UniqueSensor() {
    }

    public UniqueSensor(IMQTT imqtt) {
        this.index = imqtt.parseInt(2);
        this.address = imqtt.parseInt(2);
        this.unique = imqtt.parseCovert(16);
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getAddress() {
        return address;
    }

    public void setAddress(Integer address) {
        this.address = address;
    }

    public String getUnique() {
        return unique;
    }

    public void setUnique(String unique) {
        this.unique = unique;
    }
}
