package com.jhscale.meter.protocol;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.entity.IPackResponse;

/**
 * @author lie_w
 * @title: IProtocolResponse
 * @projectName meter-jar
 * @description: 协议响应
 * @date 2021/6/914:15
 */
public interface IProtocolResponse<T extends IPackResponse> extends IBProtocolResponse {

    /**
     * @description: 目标数据
     **/
    void target(T target) throws MeterException;

    /**
     * @description: 升级进度条完成
     **/
    default void upgrade_finish(T target) {
    }
}
