package com.jhscale.meter.protocol;

import org.apache.commons.lang3.StringUtils;

/**
 * @description: 三单主板枚举信息
 **/
public enum MainBoard {
    TAL00_4("TAL00",
            // 标签、刷枪、收银、秤台
            new String[]{"/dev/ttyS3", "/dev/ttyS5", "/dev/ttyS8", "/dev/ttyS9"},
            new String[]{"usb1", "usb2", "usb3", "usb4", "usb5", "usb6"},
            "Android 1.2.0-231028-OEM");

    private final String version;

    private final String[] ttys;

    private final String[] usb;

    private final String description;

    MainBoard(String version, String[] ttys, String[] usb, String description) {
        this.version = version;
        this.ttys = ttys;
        this.usb = usb;
        this.description = description;
    }

    /**
     * @description: 获取主板开发配置信息
     **/
    public static MainBoard version(String version) {
        if (StringUtils.isNotBlank(version)) {
            for (MainBoard board : MainBoard.values()) {
                if (board.version.equalsIgnoreCase(version)) return board;
            }
        }
        return null;
    }

    public String getVersion() {
        return version;
    }

    public String[] getTtys() {
        return ttys;
    }

    public String[] getUsb() {
        return usb;
    }

    public String getDescription() {
        return description;
    }
}
