package com.jhscale.meter.protocol;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.protocol.model.GlobalPara;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author lie_w
 * @title: BufferThread
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/2910:59
 */
public class ProtocolBufferThread extends Thread {

    // 缓冲区
    private List<byte[]> buffer = Collections.synchronizedList(new ArrayList<>());

    private ProtocolBufferEvent event;

    // 启动状态
    private boolean start = false;

    // 暂停状态
    private boolean pause = false;

    /**
     * Allocates a new {@code Thread} object. This constructor has the same
     * effect as {@linkplain #(ThreadGroup, Runnable, String) Thread}
     * {@code (null, null, gname)}, where {@code gname} is a newly generated
     * name. Automatically generated names are of the form
     * {@code "Thread-"+}<i>n</i>, where <i>n</i> is an integer.
     */
    public ProtocolBufferThread(ProtocolBufferEvent event) {
        super("ProtocolBufferEvent_Thread");
        this.event = event;
    }

    /**
     * If this thread was constructed using a separate
     * <code>Runnable</code> run object, then that
     * <code>Runnable</code> object's <code>run</code> method is called;
     * otherwise, this method does nothing and returns.
     * <p>
     * Subclasses of <code>Thread</code> should override this method.
     *
     * @see #start()
     * @see #stop()
     */
    @Override
    public void run() {
        while (this.start) {
            byte[] cache = new byte[0];
            while (this.pause) {
                while (this.buffer != null && !this.buffer.isEmpty()) {
                    byte[] next = new byte[0];
                    try {
                        next = this.buffer.remove(0);
                        if (GlobalPara.getInstance().isRunLog())
                            System.out.printf("缓冲获取[%s]：%s 当前缓冲[%s]：%s%n", next.length, ByteUtils.toHexString(next), cache.length, ByteUtils.toHexString(cache));
                    } catch (Exception e) {
                    }

                    try {
                        byte[] bytes = ByteUtils.byteMerger(cache, next);
                        if (GlobalPara.getInstance().isRunLog())
                            System.out.printf("执行传递[%s]：%s%n", bytes.length, ByteUtils.toHexString(bytes));
                        cache = this.event.execute(bytes);
                        if (GlobalPara.getInstance().isRunLog())
                            System.out.printf("执行返回[%s]：%s%n", cache.length, ByteUtils.toHexString(cache));
                    } catch (Exception e) {
                        cache = next;
                    }

                    try {
                        Thread.sleep(2);
                    } catch (InterruptedException e) {
                    }
                }

                try {
                    Thread.sleep(2);
                } catch (InterruptedException e) {
                }
            }
        }
    }

    /**
     * @description: 终止线程
     **/
    public synchronized void giveOver() {
        this.start = false;
        this.pause = false;
        try {
            Thread.sleep(500);
        } catch (InterruptedException e) {
        }
        this.clear();
    }

    /**
     * @description: 启动
     **/
    public synchronized void switchOn() {
        this.start = true;
        this.pause = !this.pause;
        this.clear();
    }

    /**
     * @description: 添加缓冲区
     **/
    public void addBuffer(byte[] bytes) {
        this.buffer.add(bytes);
    }

    /**
     * @description: 缓冲区清空
     **/
    public void clear() {
        this.buffer.clear();
    }
}
