package com.jhscale.meter.protocol.ad.em;

import com.jhscale.meter.protocol.ad.entity.assembly.*;
import com.jhscale.meter.protocol.ad.entity.disassembly.*;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: CMD
 * @projectName meter-jar
 * @description: 仪表命令
 * @date 2021/6/109:36
 */
public enum ADCMD {
    Set_Weighing_Model(1, "A", "41", "a", "61", "设置模式", SetWeighingModelADPDResponse.class, SetWeighingModelADPARequest.class),
    Obtain_MAC(2, "B", "42", "b", "62", "MAC读取命令（读取秤体蓝牙地址）", ObtainMacADPDResponse.class, ObtainMacADPARequest.class),
    Obtain_Weight(3, "C", "43", "c", "63", "重量读取命令（读取当前重量，应答模式下需使用该命令，其他模式秤体主动发送）", ObtainWeightADPDResponse.class, ObtainWeightADPARequest.class),
    Upgrade_Firmware(4, "D", "44", "d", "64", "固件升级命令", UpgradeFirmwareADPDResponse.class, UpgradeFirmwareADPARequest.class),
    Set_Zero(5, "E", "45", "e", "65", "置零命令", SetZeroADPDResponse.class, SetZeroADPARequest.class),
    Set_Peeled_Zero(6, "F", "46", "f", "66", "去皮命令", SetPeeledZeroADPDResponse.class, SetPeeledZeroADPARequest.class),
    Obtain_Version(7, "G", "47", "g", "67", "版本号读取命令", ObtainVersionADPDResponse.class, ObtainVersionADPARequest.class),
    Set_Peeled(8, "I", "49", "i", "69", "设皮命令", SetPeeledADPDResponse.class, SetPeeledADPARequest.class),
    Set_Division(9, "I + 0x80", "C9", "i + 0x80", "E9", "分度值设定命令", SetDivisionADPDResponse.class, SetDivisionADPARequest.class),
    Obtain_Division(10, "J", "4A", "j", "6A", "分度值读取命令", ObtainDivisionADPDResponse.class, ObtainDivisionADPARequest.class),
    Set_Weighing_Send_Speed(11, "K", "4B", "k", "6B", "重量发送速率设定命令", SetWeighingSendSpeedADPDResponse.class, SetWeighingSendSpeedADPARequest.class),
    Obtain_Weighing_Send_Speed(12, "L", "4C", "l", "6C", "重量发送速率读取命令", ObtainWeighingSendSpeedADPDResponse.class, ObtainWeighingSendSpeedADPARequest.class),
    Set_Boot_Zero_Range(13, "M", "4D", "m", "6D", "开机零点范围设定命令", SetBootZeroRangeADPDResponse.class, SetBootZeroRangeADPARequest.class),
    Obtain_Boot_Zero_Range(14, "N", "4E", "n", "6E", "开机零点范围读取命令", ObtainBootZeroRangeADPDResponse.class, ObtainBootZeroRangeADPARequest.class),
    Obtain_Boot_State(15, "O", "4F", "o", "6F", "开机状态读取命令", ObtainBootStateADPDResponse.class, ObtainBootStateADPARequest.class),
    Set_Boot_Zero(16, "P", "50", "p", "70", "开机零点设定命令（将当前零点设定成新的开机零点，仅在开机超限时使用）", CheckBootZeroADPDResponse.class, CheckBootZeroADPARequest.class),
    Set_Filter_Strength(17, "Q", "51", "q", "71", "滤波强度设定命令", SetFilterStrengthADPDResponse.class, SetFilterStrengthADPARequest.class),
    Obtain_Filter_Strength(18, "R", "52", "r", "72", "滤波强度读取命令", ObtainFilterStrengthADPDResponse.class, ObtainFilterStrengthADPARequest.class),
    Set_Zero_Track_Range(19, "S", "53", "s", "73", "零点跟踪范围设定命令", SetZeroTrackRangeADPDResponse.class, SetZeroTrackRangeADPARequest.class),
    Obtain_Zero_Track_Range(20, "T", "54", "t", "74", "零点跟踪范围读取命令", ObtainZeroTrackRangeADPDResponse.class, ObtainZeroTrackRangeADPARequest.class),
    Obtain_Full_Scale(21, "U", "55", "u", "75", "满量程读取命令", ObtainFullScaleADPDResponse.class, ObtainFullScaleADPARequest.class),
    Open_Close_Standard(22, "V", "56", "v", "76", "进入、退出标定状态命令", OpenCloseStrandardADPDResponse.class, OpenCloseStrandardADPARequest.class),
    Set_Full_Scale(23, "W", "57", "w", "77", "满量程设定命令", SetFullScaleADPDResponse.class, SetFullScaleADPARequest.class),
    Set_Weight_Scale(24, "X", "58", "x", "78", "重量标定命令", SetWeightScaleADPDResponse.class, SetWeightScaleADPARequest.class),
    Obtain_Internal_Code(25, "Y", "59", "y", "79", "内码读取命令", ObtainInternalCodeADPDResponse.class, ObtainInternalCodeADPARequest.class),
    Obtain_AD_Code(26, "Z", "5A", "z", "7A", "Ad码读取命令", ObtainADCodeADPDResponse.class, ObtainADCodeADPARequest.class),
    Set_GA_Coefficient(27, "Z + 0x80", "DA", "z + 0x80", "FA", "重力加速度系数设定命令", SetGACoefficientADPDResponse.class, SetGACoefficientADPARequest.class),
    Obtain_GA_Coefficient(36, "Y + 0x80", "D9", "y + 0x80", "F9", "重力加速度系数读取命令", ObtainGACoefficientADPDResponse.class, ObtainGACoefficientADPARequest.class),

    Open_Close_Temperature_Compensation(28, "A + 0x80", "C1", "a + 0x80", "E1", "温度补偿使能打开、关闭命令", OpenCloseTemperatureCompensationADPDResponse.class, OpenCloseTemperatureCompensationADPARequest.class),
    Obtain_Temperature_Compensation(29, "B + 0x80", "C2", "b + 0x80", "E2", "温度补偿使能状态读取命令", ObtainTemperatureCompensationADPDResponse.class, ObtainTemperatureCompensationADPARequest.class),
    Obtain_Temperature(30, "C + 0x80", "C3", "c + 0x80", "E3", "当前温度读取命令", ObtainTemperatureADPDResponse.class, ObtainTemperatureADPARequest.class),
    In_Exist_Temperature_Compensation(31, "D + 0x80", "C4", "d + 0x80", "E4", "进入退出温度补偿状态", InExistTemperatureCompensationADPDResponse.class, InExistTemperatureCompensationADPARequest.class),
    Set_Temperature_Zero(32, "E + 0x80", "C5", "e + 0x80", "E5", "保存当前零点", SetTemperatureZeroADPDResponse.class, SetTemperatureZeroADPARequest.class),
    Set_Temperature_Full_Scale(33, "F + 0x80", "C6", "f + 0x80", "E6", "保存当前满量程重量", SetTemperatureFullScaleADPDResponse.class, SetTemperatureFullScaleADPARequest.class),

    Set_Back_Display(34, "G + 0x80", "C7", "g + 0x80", "E7", "后显示设定命令", SetBackDisplayADPDResponse.class, SetBackDisplayADPARequest.class),
    Open_Close_Back_Light(35, "H + 0x80", "C8", "h + 0x80", "E8", "背光灯开关命令", OpenCloseBackLightADPDResponse.class, OpenCloseBackLightADPARequest.class),

    Check_Stable_And_Set_Zero_Code(36, "O + 0x80", "CF", "o + 0x80", "EF", "判稳跟零内码设定命令", CheckStableAndSetZeroCodeADPAResponse.class, CheckStableAndSetZeroCodeADPARequest.class),
    Obtain_Zero_Code_Open(37, "J + 0x80", "CA", "j + 0x80", "EA", "开机零位内码读取命令", ObtainZeroCodeOpenADPAResponse.class, ObtainZeroCodeOpenADPARequest.class),
    Restart(38, "K + 0x80", "CB", "k + 0x80", "EB", "重启命令", RestartADPAResponse.class, RestartADPARequest.class),
    Memory_Write(39, "L + 0x80", "CC", "l + 0x80", "EC", "内存写命令", MemoryWriteADPAResponse.class, MemoryWriteADPARequest.class),
    Memory_Read(40, "M + 0x80", "CD", "m + 0x80", "ED", "内存读命令", MemoryReadADPAResponse.class, MemoryReadADPARequest.class),
    Set_Internal_Code_Zero(41, "N + 0x80", "CE", "n + 0x80", "EE", "内码置零命令", SetInternalCodeZeroADPAResponse.class, SetInternalCodeZeroADPARequest.class),


    Flash_Write(42, "A + 0x40", "81", "a + 0x40", "A1", "Flash读操作", FlashWriteADPAResponse.class, FlashWriteADPARequest.class),
    Flash_Read(43, "B + 0x40", "82", "b + 0x40", "A2", "Flash写操作", FlashReadADPAResponse.class, FlashReadADPARequest.class),
    Back_Display_Reset(44, "C + 0x40", "83", "c + 0x40", "A3", "背显强制复位", BackDisplayResetADPAResponse.class, BackDisplayResetADPARequest.class),
    Lead_Status(45, "P + 0x80", "D0", "p + 0x80", "F0", "铅封状态", ObtainLeadStatusADPDResponse.class, ObtainLeadStatusADPARequest.class),
    ;

    private final Integer no;

    private final String request_ascii;

    private final String request_hex;

    private final String response_ascii;

    private final String response_hex;

    private final String content;

    private final Class clazz;

    private final Class request;

    ADCMD(Integer no,
          String request_ascii,
          String request_hex,
          String response_ascii,
          String response_hex,
          String content,
          Class clazz,
          Class request) {
        this.no = no;
        this.request_ascii = request_ascii;
        this.request_hex = request_hex;
        this.response_ascii = response_ascii;
        this.response_hex = response_hex;
        this.content = content;
        this.clazz = clazz;
        this.request = request;
    }

    /**
     * @description: 获取相应对象信息
     **/
    public static Class get_clazz(String hex) {
        if (StringUtils.isBlank(hex)) return null;
        for (ADCMD adcmd : ADCMD.values()) {
            if (hex.equalsIgnoreCase(adcmd.getResponse_hex())) return adcmd.clazz;
        }
        return null;
    }

    /**
     * @description: 获取命令信息
     **/
    public static ADCMD get_adcmd(String hex) {
        if (StringUtils.isBlank(hex)) return null;
        for (ADCMD adcmd : ADCMD.values()) {
            if (hex.equalsIgnoreCase(adcmd.getResponse_hex())) return adcmd;
        }
        return null;
    }

    /**
     * @description: 序号获取指令
     **/
    public static ADCMD no(Integer no) {
        if (Objects.isNull(no)) return null;
        for (ADCMD adcmd : ADCMD.values()) {
            if (no.equals(adcmd.getNo())) return adcmd;
        }
        return null;
    }

    public Integer getNo() {
        return no;
    }

    public String getRequest_ascii() {
        return request_ascii;
    }

    public String getRequest_hex() {
        return request_hex;
    }

    public String getResponse_ascii() {
        return response_ascii;
    }

    public String getResponse_hex() {
        return response_hex;
    }

    public String getContent() {
        return content;
    }

    public Class getClazz() {
        return clazz;
    }

    public Class getRequest() {
        return request;
    }
}
