package com.jhscale.meter.protocol.ad.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: ADProtocol
 * @projectName meter-jar
 * @description: TODO
 * @date 2021/10/1210:38
 */
public enum ADProtocol {

    默认内部协议("默认内部协议", "00", "00000000"),
    CAS主动通讯协议("CAS主动通讯协议", "01", "01010101"),
    CAS被动通讯协议("CAS被动通讯协议", "02", "02020202"),
    顶尖DigitOpBox协议("顶尖DigitOpBox协议", "03", "03030303"),
    协议B("协议B", "04", "04040404"),
    协议C("协议C", "05", "05050505"),
    协议D("协议D", "06", "06060606"),
    协议E("协议E", "07", "07070707"),
    协议G("协议G", "08", "08080808"),
    协议H("协议H", "09", "09090909"),
    协议Z("协议Z", "10", "0A0A0A0A"),
    沃立专用协议("沃立专用协议", "11", "0B0B0B0B"),
    协议I("协议I", "12", "0C0C0C0C"),;

    private String name;

    private String protocolNo;

    private String protocol;

    /**
     * @description: 获取协议
     **/
    public static ADProtocol protocol(String no) {
        if (StringUtils.isBlank(no)) return null;
        for (ADProtocol protocol : ADProtocol.values()) {
            if (no.equals(protocol.getProtocolNo())) return protocol;
        }
        return null;
    }

    ADProtocol(String name, String protocolNo, String protocol) {
        this.name = name;
        this.protocolNo = protocolNo;
        this.protocol = protocol;
    }

    public String getName() {
        return name;
    }

    public String getProtocolNo() {
        return protocolNo;
    }

    public String getProtocol() {
        return protocol;
    }
}
