package com.jhscale.meter.protocol.ad.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: SetResult
 * @projectName meter-jar
 * @description: 仪表操作结果状态
 * @date 2021-06-1410:47
 */
public enum ADResult {

    P("P", "成功", "成功", true),
    E("E", "失败", "失败", false),
    C("C", "未进入状态", "未进入(标定|温度补偿)状态", false),
    ;

    private final String sign;

    private final String display;

    private final String description;

    private final boolean result;

    ADResult(String sign, String display, String description, boolean result) {
        this.sign = sign;
        this.display = display;
        this.description = description;
        this.result = result;
    }

    public String getSign() {
        return sign;
    }

    public String getDisplay() {
        return display;
    }

    public String getDescription() {
        return description;
    }

    public boolean isResult() {
        return result;
    }

    /**
     * @description: 获取Result
     **/
    public static ADResult result(String sign) {
        if (StringUtils.isBlank(sign)) return null;
        for (ADResult result : ADResult.values()) {
            if (sign.equals(result.getSign())) return result;
        }
        return ADResult.E;
    }
}
