package com.jhscale.meter.protocol.ad.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author Loveven
 * @title: TemplatureState
 * @projectName meter-jar
 * @description: 温度补偿开关状态
 * @date 2021-06-1415:23
 */
public enum BackLight {

    CLOSE(0, "00", "关闭背光灯"),
    OPEN(1, "01", "打开背光灯");

    private int state;

    private String hex;

    private String description;

    BackLight(int state, String hex, String description) {
        this.state = state;
        this.hex = hex;
        this.description = description;
    }

    /**
     * @description: 获取温度补偿开关状态
     **/
    public static BackLight getState(Integer state) {
        if (Objects.isNull(state)) return null;
        for (BackLight templatureState : BackLight.values()) {
            if (state == templatureState.getState()) return templatureState;
        }
        return null;
    }

    /**
     * @description: 获取温度补偿开关状态
     **/
    public static BackLight getState(String state) {
        if (StringUtils.isBlank(state)) return null;
        for (BackLight templatureState : BackLight.values()) {
            if (state.equals(templatureState.getHex())) return templatureState;
        }
        return null;
    }

    public int getState() {
        return state;
    }

    public String getHex() {
        return hex;
    }

    public String getDescription() {
        return description;
    }


}
