package com.jhscale.meter.protocol.ad.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: BootState
 * @projectName meter-jar
 * @description: 开机状态
 * @date 2021-06-1410:30
 */
public enum BootState {

    P("P", "开机成功"),
    H("H", "开机超上限"),
    L("L", "开机超下限"),;

    private String state;

    private String description;

    BootState(String state, String description) {
        this.state = state;
        this.description = description;
    }

    public String getState() {
        return state;
    }

    public String getDescription() {
        return description;
    }

    /**
     * @description: 获取开机状态枚举
     **/
    public static BootState bootState(String state) {
        if (StringUtils.isBlank(state)) return null;
        for (BootState bootState : BootState.values()) {
            if (state.equals(bootState.getState())) return bootState;
        }
        return null;
    }
}
