package com.jhscale.meter.protocol.ad.em;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: Division
 * @projectName meter-jar
 * @description: 分度枚举
 * @date 2021/6/1615:25
 */
public enum Division {

    ZERO(0, "00", "单分度", "1"),
    ONE(1, "01", "双分度", "1,2"),
    TWO(2, "02", "单分度", "2"),
    THREE(3, "03", "双分度", "2,5"),
    FOUR(4, "04", "单分度", "5"),
    FIVE(5, "05", "双分度", "5,10"),
    SIX(6, "06", "单分度", "10"),
    SEVEN(7, "07", "双分度", "10,20"),
    EIGHT(8, "08", "单分度", "20"),
    NINE(9, "09", "双分度", "20,50"),
    TEN(10, "0A", "单分度", "50");

    private int division;

    private String hex;

    private String type;

    private String vals;

    Division(int division, String hex, String type, String vals) {
        this.division = division;
        this.hex = hex;
        this.type = type;
        this.vals = vals;
    }

    /**
     * @description:
     **/
    public static Division division(Integer val) {
        if (Objects.isNull(val)) return null;
        for (Division division : Division.values()) {
            if (division.getDivision() == val) return division;
        }
        return null;
    }

    /**
     * @description:
     **/
    public static Division division(String val) {
        if (StringUtils.isBlank(val)) return null;
        for (Division division : Division.values()) {
            if (val.equals(division.hex)) return division;
        }
        return null;
    }

    /**
     * @description:
     **/
    public List<Integer> divisionVals() {
        String[] vals = this.vals.split(",");
        if (vals != null && vals.length > 0) {
            List<Integer> divisionVals = new ArrayList<>();
            for (String val : vals) {
                try {
                    divisionVals.add(Integer.parseInt(val));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Collections.emptyList();
    }

    public int getDivision() {
        return division;
    }

    public String getHex() {
        return hex;
    }

    public String getType() {
        return type;
    }

    public String getVals() {
        return vals;
    }
}
