package com.jhscale.meter.protocol.ad.em;

/**
 * @author lie_w
 * @title: RangeDivision
 * @projectName meter-jar
 * @description: 满量程分度
 * @date 2021/7/1312:42
 */
public enum RangeDivision {

    Six(6000, 3000, 3, new Division[]{Division.TWO, Division.ONE, Division.ZERO}),
    Fifteen(15000, 6000, 3, new Division[]{Division.FOUR, Division.THREE, Division.TWO, Division.ONE, Division.ZERO}),
    Thirty(30000, 15000, 3, new Division[]{Division.SIX, Division.FIVE, Division.FOUR, Division.THREE, Division.TWO}),;

    // 满量程数值
    private int range;

    // 双分度切换点
    private int switchRange;

    private int flot;

    // 量程支持分度值
    private Division[] divisions;

    RangeDivision(int range, int switchRange, int flot, Division[] divisions) {
        this.range = range;
        this.switchRange = switchRange;
        this.flot = flot;
        this.divisions = divisions;
    }

    /**
     * @description: 获取满量程信息
     **/
    public static RangeDivision getRangeDivision(int range) {
        RangeDivision rangeDivision = null;
        for (RangeDivision division : RangeDivision.values()) {
            if (range == division.range) {
                rangeDivision = division;
                break;
            }
        }
        if (rangeDivision == null) rangeDivision = RangeDivision.Thirty;
        return rangeDivision;
    }

    public int getRange() {
        return range;
    }

    public int getSwitchRange() {
        return switchRange;
    }

    public int getFlot() {
        return flot;
    }

    public Division[] getDivisions() {
        return divisions;
    }
}
