package com.jhscale.meter.protocol.ad.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: Strandard
 * @projectName meter-jar
 * @description: 进出标定
 * @date 2021/6/1616:25
 */
public enum Strandard {

    EXIST(0, "00", "退出标定状态"),
    IN(1, "01", "进入标定状态");

    private int strandard;

    private String hex;

    private String description;

    Strandard(int strandard, String description) {
        this.strandard = strandard;
        this.description = description;
    }

    Strandard(int strandard, String hex, String description) {
        this.strandard = strandard;
        this.hex = hex;
        this.description = description;
    }

    /**
     * @description: 获取标定状态
     **/
    public static Strandard strandard(Integer strandard) {
        if (strandard == null) return null;
        for (Strandard sd : Strandard.values()) {
            if (strandard == sd.getStrandard()) return sd;
        }
        return null;
    }

    /**
     * @description: 获取标定状态
     **/
    public static Strandard strandard(String strandard) {
        if (StringUtils.isBlank(strandard)) return null;
        for (Strandard sd : Strandard.values()) {
            if (strandard.equals(sd.getHex())) return sd;
        }
        return null;
    }

    public int getStrandard() {
        return strandard;
    }

    public String getHex() {
        return hex;
    }

    public String getDescription() {
        return description;
    }
}
