package com.jhscale.meter.protocol.ad.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author Loveven
 * @title: TemplatureState
 * @projectName meter-jar
 * @description: 温度补偿开关状态
 * @date 2021-06-1415:23
 */
public enum TemplatureInExistState {

    CLOSE(0, "00", "退出温度补偿状态"),
    OPEN(1, "01", "进入温度补偿状态");

    private int state;

    private String hex;

    private String description;

    TemplatureInExistState(int state, String hex, String description) {
        this.state = state;
        this.hex = hex;
        this.description = description;
    }

    /**
     * @description: 获取温度补偿开关状态
     **/
    public static TemplatureInExistState switchState(Integer state) {
        if (Objects.nonNull(state)) return null;
        for (TemplatureInExistState templatureState : TemplatureInExistState.values()) {
            if (state == templatureState.getState()) return templatureState;
        }
        return null;
    }

    /**
     * @description: 获取温度补偿开关状态
     **/
    public static TemplatureInExistState switchState(String state) {
        if (StringUtils.isBlank(state)) return null;
        for (TemplatureInExistState templatureState : TemplatureInExistState.values()) {
            if (state.equals(templatureState.getHex())) return templatureState;
        }
        return null;
    }

    public String getHex() {
        return hex;
    }

    public int getState() {
        return state;
    }

    public String getDescription() {
        return description;
    }
}
