package com.jhscale.meter.protocol.ad.em;

import java.util.Objects;

/**
 * @author Loveven
 * @title: TemplatureState
 * @projectName meter-jar
 * @description: 温度补偿开关状态
 * @date 2021-06-1415:23
 */
public enum TemplatureSwitchState {

    CLOSE(0, "00", "温度补偿功能关闭"),
    OPEN(1, "01", "温度补偿功能打开");

    private int state;

    private String hex;

    private String description;

    TemplatureSwitchState(int state, String description) {
        this.state = state;
        this.description = description;
    }

    TemplatureSwitchState(int state, String hex, String description) {
        this.state = state;
        this.hex = hex;
        this.description = description;
    }

    public int getState() {
        return state;
    }

    public String getHex() {
        return hex;
    }

    public String getDescription() {
        return description;
    }

    /**
     * @description: 获取温度补偿开关状态
     **/
    public static TemplatureSwitchState switchState(Integer state) {
        if (Objects.isNull(state)) return null;
        for (TemplatureSwitchState templatureState : TemplatureSwitchState.values()) {
            if (state == templatureState.getState()) return templatureState;
        }
        return null;
    }
}
