package com.jhscale.meter.protocol.ad.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ZeroTrackRange
 * @projectName meter-jar
 * @description: 零点跟踪范围
 * @date 2021/6/1616:39
 */
public enum ZeroTrackRange {

    ZERO(0, "00", "不跟踪"),
    ONE(1, "01", "0.6e"),
    TWO(2, "02", "0.8e"),
    THREE(3, "03", "1.5e"),
    FOUR(4, "04", "2.5e"),
    FIVE(5, "05", "3.5e"),;

    private int val;

    private String hex;

    private String type;

    ZeroTrackRange(int val, String hex, String type) {
        this.val = val;
        this.hex = hex;
        this.type = type;
    }

    /**
     * @description: 获取温度补偿开关状态
     **/
    public static ZeroTrackRange trackrange(Integer val) {
        if (Objects.isNull(val)) return null;
        for (ZeroTrackRange trackRange : ZeroTrackRange.values()) {
            if (val == trackRange.getVal()) return trackRange;
        }
        return null;
    }

    /**
     * @description: 获取温度补偿开关状态
     **/
    public static ZeroTrackRange trackrange(String val) {
        if (StringUtils.isBlank(val)) return null;
        for (ZeroTrackRange trackRange : ZeroTrackRange.values()) {
            if (val.equals(trackRange.getHex())) return trackRange;
        }
        return null;
    }

    public int getVal() {
        return val;
    }

    public String getHex() {
        return hex;
    }

    public String getType() {
        return type;
    }
}
