package com.jhscale.meter.protocol.ad.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.entity.PackAssemblyRequest;
import com.jhscale.meter.utils.CodeUtils;
import com.jhscale.meter.utils.Constant;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ADPackAssembly
 * @projectName meter-jar
 * @description: (组装请求)
 * @date 2021/6/109:36
 */
public class ADPackAssemblyRequest<T extends ADPackAssemblyResponse> implements PackAssemblyRequest<ADPackAssemblyResponse> {

    // 命令
    private ADCMD adcmd;

    // 内容体
    protected StringBuffer inner;

    public ADPackAssemblyRequest() {
        this.inner = new StringBuffer();
    }

    public ADPackAssemblyRequest(ADCMD adcmd) {
        this();
        this.adcmd = adcmd;
    }

    public ADCMD getAdcmd() {
        return adcmd;
    }

    public void setAdcmd(ADCMD adcmd) {
        this.adcmd = adcmd;
    }

    /**
     * @description: 协议执行器
     **/
    @Override
    public T execute() throws MeterException {
        if (Objects.isNull(this.adcmd))
            throw new MeterException(MeterStateEnum.AD指令不存在);

        int frameNum = (int) (Math.random() * 255);
        String frame = Integer.toHexString(frameNum);
        if (frame.length() % 2 != 0) frame = "0" + frame;

        String cmd = this.adcmd.getRequest_hex();
        int cmdNum = Integer.parseInt(cmd, 16);
        int temp = cmdNum + CodeUtils.codeArr[(frameNum + 1) % 0x0100];
        if (temp > 0xff) temp -= 0x0100;
        cmd = Integer.toHexString(temp);
        if (cmd.length() % 2 != 0) cmd = "0" + cmd;

        int dataNum = 0, assembleDataLength = 0;// 内容值，组装数据长度

        // 内容体组装
        this.assembly();

        StringBuilder builder = null;
        if (this.inner.length() > 0) {
            builder = new StringBuilder();
            // 存在内容体
            if (this.inner.length() % 2 != 0)
                throw new MeterException(MeterStateEnum.AD_数据格式错误);

            assembleDataLength = this.inner.length();
            for (int i = 0; i < (this.inner.length() / 2); i++) {
                String bit = this.inner.substring(i * 2, i * 2 + 2);
                int bitVal = Integer.parseInt(bit, 16);
                dataNum += bitVal;
                bitVal += CodeUtils.codeArr[(frameNum + 2 + i) % 0x0100];
                if (bitVal > 0xff) bitVal -= 0x0100;
                String bitData = Integer.toHexString(bitVal);
                builder.append(bitData.length() % 2 != 0 ? "0" + bitData : bitData);
            }
        }

        String length = Integer.toHexString((cmd.length() + assembleDataLength) / 2);
        if (length.length() % 2 != 0) length = "0" + length;
        String verify = Integer.toHexString(frameNum + cmdNum + dataNum);
        verify = verify.substring(verify.length() - 2);

        String cmdData = Constant.TOP + length + frame + cmd + (builder != null ? builder.toString() : "") + verify + Constant.END;
        cmdData = CodeUtils.encode(cmdData);
        return (T) new ADPackAssemblyResponse(this.adcmd, frameNum, cmdData);
    }

    /**
     * @description: 是否加密
     **/
    @Override
    public boolean code() {
        return false;
    }

    /**
     * @param code
     * @description: 是否加密
     */
    @Override
    public void code(boolean code) {

    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
    }

}
