package com.jhscale.meter.protocol.ad.entity;

import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.entity.PackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: ADPackAssembly
 * @projectName meter-jar
 * @description: (组装响应)
 * @date 2021/6/109:36
 */
public class ADPackAssemblyResponse extends PackAssemblyResponse {

    // 发送CMD
    private String cmd;

    // CMD
    private ADCMD adcmd;

    public ADPackAssemblyResponse() {
    }

    public ADPackAssemblyResponse(ADCMD adcmd, int nid, String cmd) {
        super(nid);
        this.adcmd = adcmd;
        this.cmd = cmd;
    }

    public ADPackAssemblyResponse(String cmd) {
        this.cmd = cmd;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public ADCMD getAdcmd() {
        return adcmd;
    }

    public void setAdcmd(ADCMD adcmd) {
        this.adcmd = adcmd;
    }

    /**
     * @description: 操作指令
     **/
    @Override
    public int command() {
        return this.adcmd.getNo();
    }

    /**
     * @description: HEX CMD
     **/
    public byte[] HEX() {
        return ByteUtils.fromHexString(this.cmd);
    }
}
