package com.jhscale.meter.protocol.ad.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.entity.PackDisassemblyRequest;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CodeUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * @author lie_w
 * @title: ADPackDisassemblyRequest
 * @projectName meter-jar
 * @description: (解析请求)
 * @date 2021/6/1023:09
 */
public class ADPackDisassemblyRequest<T extends ADPackDisassemblyResponse> implements PackDisassemblyRequest<ADPackDisassemblyResponse> {

    // 缓冲区解码后字节流
    private byte[] bytes;

    // HEX字节源 串口收到的HEX数据
    private String cmd;

    // 命令字节
    private String hex;

    public ADPackDisassemblyRequest() {
    }

    /**
     * @description: HEX码解析
     **/
    public ADPackDisassemblyRequest(String cmd) {
        this.cmd = cmd;
    }

    /**
     * @description: 解码后解析
     **/
    public ADPackDisassemblyRequest(byte[] bytes) {
        this.bytes = bytes;
    }

    /**
     * @description: 协议执行器
     **/
    @Override
    public T execute() throws MeterException {
        if ((this.bytes == null || this.bytes.length == 0) && StringUtils.isBlank(cmd))
            throw new MeterException(MeterStateEnum.AD响应指令无效);

        String lengthStr, frameStr, cmdStr, dataStr, verifyStr;// 长度,帧号,命令/应答,数据内容,校验字段
        if (StringUtils.isNotBlank(this.cmd)) {
            // HEX字节源 串口收到的HEX数据 解析
            this.cmd = this.cmd.trim().replace(" ", "");
            String source_cmd = CodeUtils.decode(this.cmd);
            String cmdData = CodeUtils.checkData(source_cmd);

            lengthStr = cmdData.substring(0, 2);// 长度
            frameStr = cmdData.substring(2, 4); // 帧号
            cmdStr = cmdData.substring(4, 6);// 命令/应答
            dataStr = cmdData.substring(6, cmdData.length() - 2);// 数据内容
            verifyStr = cmdData.substring(cmdData.length() - 2, cmdData.length());// 校验字段
            if (Integer.parseInt(lengthStr, 16) != (cmdStr.length() + dataStr.length()) / 2)
                throw new MeterException(MeterStateEnum.AD数据包长度检查错误);
        } else {
            lengthStr = ByteUtils.toHexString(Arrays.copyOfRange(this.bytes, 1, 2));// 长度
            frameStr = ByteUtils.toHexString(Arrays.copyOfRange(this.bytes, 2, 3));// 帧号
            byte[] cmdb = Arrays.copyOfRange(this.bytes, 3, 4); // 命令/应答
            cmdStr = ByteUtils.toHexString(cmdb);// 命令/应答
            byte[] data = Arrays.copyOfRange(this.bytes, 4, this.bytes.length - 2);
            dataStr = ByteUtils.toHexString(data);// 数据内容
            verifyStr = ByteUtils.toHexString(Arrays.copyOfRange(this.bytes, this.bytes.length - 2, this.bytes.length - 1)); // 校验
            if (Integer.parseInt(lengthStr, 16) != data.length + cmdb.length) {
                throw new MeterException(MeterStateEnum.AD数据包长度检查错误);
            }
        }

        int frame = Integer.parseInt(frameStr, 16);
        int cmdVal = Integer.parseInt(cmdStr, 16) - CodeUtils.codeArr[(frame + 1) % 0x0100];
        if (cmdVal < 0) cmdVal += 0x0100;
        this.hex = Integer.toHexString(cmdVal);
        String cmd = ByteUtils.hex2Ascii(this.hex);

        int dataVal = 0;
        StringBuffer content = new StringBuffer();
        if (StringUtils.isNotBlank(dataStr)) {
            for (int i = 0; i < (dataStr.length() / 2); i++) {
                String bit = dataStr.substring(i * 2, i * 2 + 2);
                int bitVal = Integer.parseInt(bit, 16) - CodeUtils.codeArr[(frame + 2 + i) % 0x0100];
                if (bitVal < 0) bitVal += 0x0100;
                dataVal += bitVal;
                String bitData = Integer.toHexString(bitVal);
                content.append(bitData.length() % 2 != 0 ? 0 + bitData : bitData);
            }
        }

        String cVerify = Integer.toHexString(frame + cmdVal + dataVal);
        cVerify = cVerify.substring(cVerify.length() - 2, cVerify.length());
        if (!cVerify.equalsIgnoreCase(verifyStr))
            throw new MeterException(MeterStateEnum.AD校验码无效);

        ADCMD adcmd = ADCMD.get_adcmd(this.hex);
        ADPackDisassemblyResponse response = (ADPackDisassemblyResponse) this.response();
        response.setNid(frame);
        response.length = Integer.parseInt(lengthStr, 16);
        response.cmd = cmd;
        response.adcmd = adcmd;
        response.setCommand(adcmd.getNo());
        response.content = content.toString().trim();
        response = response.disassembly();
        if (response == null)
            throw new MeterException(MeterStateEnum.子包拆解失败);
        return (T) response;
    }

    /**
     * @description: 获取返回值类型
     **/
    @Override
    public <T extends IPackResponse> Class<T> getClazz() {
        return ADCMD.get_adcmd(this.hex).getClazz();
    }

    /**
     * @description: 是否加密
     **/
    @Override
    public boolean code() {
        return false;
    }

    /**
     * @param code
     * @description: 是否加密
     */
    @Override
    public void code(boolean code) {

    }

}
