package com.jhscale.meter.protocol.ad.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.ADResult;
import com.jhscale.meter.protocol.entity.PackDisassemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: ADPackDisassemblyRequest
 * @projectName meter-jar
 * @description: (解析响应)
 * @date 2021/6/1023:09
 */
public class ADPackDisassemblyResponse extends PackDisassemblyResponse {

    // 结果
    protected ADResult result = ADResult.P;

    // 标识
    protected String resultHex = ADResult.P.getSign();

    // 长度
    protected int length;

    // 命令
    protected String cmd;

    // 命令内容
    protected ADCMD adcmd;

    // 内容
    protected String content;

    /**
     * @return
     * @description: 内容解析
     */
    @Override
    public ADPackDisassemblyResponse disassembly() throws MeterException {
        try {
            this.result = this.result();
            this.resultHex = this.strVal();
        } catch (Exception e) {
            JLog.error("{} EXP:{}", this.getClass().getSimpleName(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_操作结果解析失败);
        }
        return this;
    }

    public ADResult getResult() {
        return result;
    }

    public String getResultHex() {
        return resultHex;
    }

    public int getLength() {
        return length;
    }

    public String getCmd() {
        return cmd;
    }

    public ADCMD getAdcmd() {
        return adcmd;
    }

    /**
     * @description: INT Val
     **/
    protected int intVal() {
        return Integer.parseInt(content, 16);
    }

    /**
     * @description: 操作结果
     **/
    protected ADResult result() {
        return ADResult.result(this.strVal());
    }

    /**
     * @description: String Val
     **/
    protected String strVal() {
        return new String(ByteUtils.fromHexString(this.content));
    }
}
